/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xdecode.h
 *       configuration space and target decoders
 * -----------------------------------------------------------------*/

#ifndef XDECODE_H_INCLUDED
#define XDECODE_H_INCLUDED

#include <xdyndefs.h>
#include <xtdecdef.h>

#ifdef __cplusplus
extern "C" {
#endif
  
/* -----------------------------------------------------------------
 * Configuration Space Programming Functions (work on db only)
 * ----------------------------------------------------------------- */

CLI bx_errtype EXPORT  BestXConfRegSet(  /* @confregset */
  bx_handletype handle,
  bx_int32      offset,                 
  bx_int32      val                      
);

CLI bx_errtype EXPORT  BestXConfRegGet(  /* @confregget */
  bx_handletype handle,
  bx_int32      offset,                  
  bx_int32      *val                         /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT  BestXConfRegMaskSet( /* @confregmaskset */
  bx_handletype handle,
  bx_int32      offset,                
  bx_int32      val
);

CLI bx_errtype EXPORT  BestXConfRegMaskGet( /* @confregmaskget */
  bx_handletype handle,
  bx_int32      offset,
  bx_int32      *val                        /* #RETURN "0x%08lx" */
);
  
CLI bx_errtype EXPORT  BestXConfRegDefaultGet( /* @confregdefget */
  bx_handletype handle,
  bx_int32      offset,                  
  bx_int32      *val       /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT  BestXConfRegMaskDefaultGet( /* @confregmaskdefget */
  bx_handletype handle,
  bx_int32      offset,                  
  bx_int32      *val    /* #RETURN "0x%08lx" */
);

/*****************************************************************************
 * direct access to HW from here! (except offline mode, of course)
 *****************************************************************************/
  
CLI bx_errtype EXPORT  BestXConfRegWrite( /* @confregwrite */
  bx_handletype handle,
  bx_int32      offset,   
  bx_int32      val    
);

CLI bx_errtype EXPORT  BestXConfRegRead( /* @confregread */
  bx_handletype handle,
  bx_int32      offset,
  bx_int32      *val                         /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT  BestXConfRegMaskWrite( /* @confregmaskwrite */
  bx_handletype handle,
  bx_int32      offset,
  bx_int32      val
);

CLI bx_errtype EXPORT  BestXConfRegMaskRead( /* @confregmaskread */
  bx_handletype handle,
  bx_int32      offset,
  bx_int32      *val    /* #RETURN "0x%08lx" */
);

/*****************************************************************************
 * configspace prog/read/write functions
 *****************************************************************************/

CLI bx_errtype EXPORT BestXTConfigProg(      /* @tconfigprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXTConfigRead(      /* @tconfigread */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXTConfigCheck(      /* @tconfigcheck */
  bx_handletype  handle,
  bx_bool * pResult                /* #RETURN "%d" */
);

bx_errtype EXPORT BestXTDecoderProg(         /* @tdecprog */
  bx_handletype   handle,
  bx_int8ptr  LoaderCode,
  bx_int32ptr Loaderlength
);

CLI  bx_errtype EXPORT BestXTDecoderRead(    /* @tdecread */
  bx_handletype   handle
);

CLI  bx_errtype EXPORT BestXTDecoderCheck(    /* @tdeccheck */
  bx_handletype   handle,
  bx_bool * pResult           /* #RETURN "%d" */
);

/* ------------------------------------------------------------------------
 * PCI Target Programming Functions
 * ------------------------------------------------------------------------ */

CLI  bx_errtype EXPORT BestXTDecoderDefaultSet( /* @tdecdefset */
  bx_handletype  handle
);

CLI  bx_errtype EXPORT BestXTDecoderSet( /* @tdecset */
  bx_handletype   handle,
  bx_dectype      dec,
  bx_decproptype  prop,                  
  bx_int32        val
);


CLI bx_errtype EXPORT BestXTDecoderGet( /* @tdecget */ 
  bx_handletype   handle,
  bx_dectype      dec,
  bx_decproptype  prop,                
  bx_int32        *val                 /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXTDecoderAllSet( /* @tdecallset */ 
  bx_handletype   handle,
  bx_dectype      dec,
  bx_int32        location,
  bx_int32        size,
  bx_int32        prefetch,
  bx_int32        baselo,
  bx_int32        basehi,
  bx_int32        resource,
  bx_int32        resbase,
  bx_int32        ressize,
  bx_int32        compare
);


bx_errtype EXPORT BestXTConfigPUCodeGet(
  bx_handletype handle,
  bx_int8ptr LoaderCode,
  bx_int32ptr LoaderLength
);

/*****************************************************************************
 * used by GUI (not documented publicly)
 *****************************************************************************/
bx_errtype EXPORT BestXTDecoderInfo (
  bx_handletype handle,
  bx_dectype decoder,
  bx_decproptype prop,
  const bx_param_infotype ** pParam
  );

/*****************************************************************************
 * convenience function (not documented)
 *****************************************************************************/

CLI bx_errtype EXPORT BestXTDecoderAddrRead ( /* @tdecaddrread */
  bx_handletype handle,
  bx_dectype decoder,          /* @dec */
  bx_int32 *pAddress,          /* #RETURN "0x%08lx" */
  bx_int32 *pAddressHi         /* #RETURN "0x%08lx" */
);


#ifdef __cplusplus
}
#endif

#endif




